% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetMultiQuery.R
\name{dbGetMultiQuery}
\alias{dbGetMultiQuery}
\title{Query a database with multiple query actions and one, final, select statement.}
\usage{
dbGetMultiQuery(conn, conn_type = "JDBC", sql_path, pattern = NULL, replacement = NULL)
}
\arguments{
\item{conn}{A database connection object}

\item{conn_type}{A string indicating if the connection type is a JDBC or ODBC connection - accepts "JDBC" or "ODBC" as arguments, defaults to "JDBC"}

\item{sql_path}{Character vector pointing to SQL script}

\item{pattern}{A character object you would like to substitute in the SQL script - this is not required and defaults to NULL. Calls gsub under the hood, so use regex for pattern identification. You may provide a single string or a vector of strings equal in length to the vector of strings in the replacement field.}

\item{replacement}{A character vector replacing the pattern specified - this is not required and defaults to NULL. Calls gsub under the hood, so use regex for pattern identification. You may provide a single string or a vector of strings equal in length to the vector of strings in the replacement field.}
}
\value{
A data object
}
\description{
Requires a DBI workflow that creates a connection with a relational database per DBI: https://dbi.r-dbi.org/. This function is an extension of the DBI::dbGetQuery and RJDBC::dbSendUpdate functions.
}
