% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SIR_threshold_opt.R
\name{plot.SIR_threshold_opt}
\alias{plot.SIR_threshold_opt}
\title{Graphical output of SIR_threshold_opt}
\usage{
\method{plot}{SIR_threshold_opt}(x, choice = "", ...)
}
\arguments{
\item{x}{A SIR_threshold_opt object}

\item{choice}{the graph to plot: 
\itemize{
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "opt_lambda" Plot the choice of \eqn{\lambda_{opt}}.
  \item "cos2_selec" Plot the evolution of \eqn{cos^2} and variable selection according to 
  \eqn{\lambda}.
  \item "regul_path" Plot the regularization path of \eqn{\hat{b}}.
  \item "" Plot every graphs (default).
}}

\item{\ldots}{arguments to be passed to methods, such as graphical parameters (not used here).}
}
\value{
No return value
}
\description{
Display the 10 first eigen values,the estimated index versus Y of the SIR model,
the evolution of \eqn{cos^2} and variable selection according to \eqn{\lambda}, and the 
regularization path of \eqn{\hat{b}}.
}
\examples{
# Generate Data
set.seed(10)
n <- 200
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply SIR with soft thresholding
res = SIR_threshold_opt(Y,X,H=10,n_lambda=100,thresholding="soft")

# Estimated index versus Y
plot(res,choice="estim_ind")

# Choice of optimal lambda
plot(res,choice="opt_lambda")

# Evolution of cos^2 and var selection according to lambda
plot(res,choice="cos2_selec")

# Regularization path
plot(res,choice="regul_path")
}
