% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sip_pair.R
\name{sip_pair}
\alias{sip_pair}
\title{Single-iteration paired permutation for large-scale biobank data
with relatedness}
\usage{
sip_pair(
  df = NULL,
  id.var = NULL,
  sex.var = NULL,
  male.val = NULL,
  female.val = NULL,
  geno.vars = NULL,
  within.sex = TRUE,
  seed = NULL,
  rel.df = NULL,
  rid.vars = NULL,
  ibd.var = NULL
)
}
\arguments{
\item{df, rel.df}{Data frame}

\item{id.var, sex.var, ibd.var}{Strings}

\item{male.val, female.val}{Strings or integers}

\item{geno.vars, rid.vars}{Character vectors}

\item{within.sex}{Boolean, defaults to TRUE}

\item{seed}{Number}
}
\value{
Data frame
}
\description{
# This function performs paired permutation for permuting phenotype
vectors among related individuals in biobank data.
}
\details{
The function requires the following inputs:

1) A sample-by-variable data frame with phenotypes and covariates.
Column names should include an ID variable, sex variable,
genotypic covariate names, phenotypic covariate names, and phenotype names.
(N.B. a secondary ID variable can be included
in the genotypic covariate names.)

2) A string identifying the ID variable name (e.g., id.var="ID").

3) A vector of genotypic covariates
(e.g., geno.vars=c("ID2","Batch","PC1","PC2",...)).

4) A relatedness data frame containing identity-by-descent (IBD) for
pairs of individuals in the sample-by-variable data frame.
Column names should include two ID variables and an IBD variable.

5) A vector of the 2 ID variable names in the relatedness data frame.
(e.g., rid.vars=c("ID1","ID2")).

6) A string identifying the IBD variable name (e.g., ibd.var="PropIBD").

7) Optional: within.sex = FALSE. Default is within.sex = TRUE
and will permute males and females separately.

8) If within.sex = TRUE (the default), a string identifying the
sex variable name (e.g., sex.var="Inferred_Sex").

9) If within.sex = TRUE (the default), male and female values
in the sex vector (e.g., male.val=1, female.val=2).

10) Optional: a seed for sampling. If a seed is not provided, one will be
chosen randomly during the sampling process (e.g., seed=123).

11) N.B. Any column names not specified in (2)-(9) are assumed to be
phenotypes or phenotypic covariates.
}
\examples{
sip_pair(df = sipPair_exampleData, id.var = "IID",
sex.var = "SEX", male.val = "M", female.val = "F",
geno.vars = c("FID","BATCH",paste0("PC",1:4)),
rel.df = sipPair_relatednessData, rid.vars=c("IID1","IID2"),
ibd.var="PropIBD")
}
