% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistWMat.R
\name{DistWMat}
\alias{DistWMat}
\title{Distance weights matrix (Inverse distance, Exponential distance or Double-Distance matrix)}
\usage{
DistWMat(
  distMat,
  distCutOff = NULL,
  type = "inverse",
  alpha = NULL,
  mevn = FALSE
)
}
\arguments{
\item{distMat}{distance matrix}

\item{distCutOff}{cutoff distance. Default = the maximal value from the distance matrix.}

\item{type}{the type of distance matrix c("inverse","expo","doubled"). Default = "inverse".}

\item{alpha}{power (positive exponent), default 1 if type="inverse", 0.01 if type="expo" and 2 if type="double"}

\item{mevn}{logical, default FALSE. If TRUE, max-eigenvalue normalization is performed.}
}
\value{
\item{W}{spatial weights matrix (Default, not normalized)}
}
\description{
This function calculates the spatial distance weights matrix (inverse, exponential or
double-distance), with a given cutoff distance and a positive exponent (alpha).
}
\examples{
## distance between centroids of NUTS3 regions in Germany (in meters)
data(gN3dist, package = "SDPDmod")
##inverse distance matrix with cutoff 100000 meters
W1    <- DistWMat(distMat = gN3dist, distCutOff = 100000)
dist2 <- gN3dist/1000 ##distance in km
## normalized exponential distance matrix
W2    <- DistWMat(distMat=dist2, distCutOff = 100, type = "expo",
                  alpha = 2, mevn = TRUE)

}
\seealso{
\code{\link{InvDistMat}} \code{\link{ExpDistMat}} \code{\link{DDistMat}} \code{vignette("spatial_matrices", package = "SDPDmod")}
}
\author{
Rozeta Simonovska
}
