% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvSDTree.R
\name{cvSDTree}
\alias{cvSDTree}
\title{Cross-validation for the SDTree}
\usage{
cvSDTree(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  max_leaves = NULL,
  cp = 0,
  min_sample = 5,
  mtry = NULL,
  fast = TRUE,
  Q_type = "trim",
  trim_quantile = 0.5,
  q_hat = 0,
  Qf = NULL,
  A = NULL,
  gamma = 0.5,
  max_candidates = 100,
  nfolds = 3,
  cp_seq = NULL,
  mc.cores = 1,
  Q_scale = TRUE
)
}
\arguments{
\item{formula}{Object of class \code{formula} or describing the model to fit 
of the form \code{y ~ x1 + x2 + ...} where \code{y} is a numeric response and 
\code{x1, x2, ...} are vectors of covariates. Interactions are not supported.}

\item{data}{Training data of class \code{data.frame} containing the variables in the model.}

\item{x}{Predictor data, alternative to \code{formula} and \code{data}.}

\item{y}{Response vector, alternative to \code{formula} and \code{data}.}

\item{max_leaves}{Maximum number of leaves for the grown tree.}

\item{cp}{Complexity parameter, minimum loss decrease to split a node. 
A split is only performed if the loss decrease is larger than \code{cp * initial_loss}, 
where \code{initial_loss} is the loss of the initial estimate using only a stump.}

\item{min_sample}{Minimum number of observations per leaf. 
A split is only performed if both resulting leaves have at least 
\code{min_sample} observations.}

\item{mtry}{Number of randomly selected covariates to consider for a split, 
if \code{NULL} all covariates are available for each split.}

\item{fast}{If \code{TRUE}, only the optimal splits in the new leaves are 
evaluated and the previously optimal splits and their potential loss-decrease are reused. 
If \code{FALSE} all possible splits in all the leaves are reevaluated after every split.}

\item{Q_type}{Type of deconfounding, one of 'trim', 'pca', 'no_deconfounding'. 
'trim' corresponds to the Trim transform \insertCite{Cevid2020SpectralModels}{SDModels} 
as implemented in the Doubly debiased lasso \insertCite{Guo2022DoublyConfounding}{SDModels}, 
'pca' to the PCA transformation\insertCite{Paul2008PreconditioningProblems}{SDModels}. 
See \code{\link{get_Q}}.}

\item{trim_quantile}{Quantile for Trim transform, 
only needed for trim and DDL_trim, see \code{\link{get_Q}}.}

\item{q_hat}{Assumed confounding dimension, only needed for pca, 
see \code{\link{get_Q}}.}

\item{Qf}{Spectral transformation, if \code{NULL} 
it is internally estimated using \code{\link{get_Q}}.}

\item{A}{Numerical Anchor of class \code{matrix}. See \code{\link{get_W}}.}

\item{gamma}{Strength of distributional robustness, \eqn{\gamma \in [0, \infty]}. 
See \code{\link{get_W}}.}

\item{max_candidates}{Maximum number of split points that are 
proposed at each node for each covariate.}

\item{nfolds}{Number of folds for cross-validation. 
It is recommended to not use more than 5 folds if the number of covariates 
is larger than the number of observations. In this case the spectral 
transformation could differ to much if the validation data is 
substantially smaller than the training data.}

\item{cp_seq}{Sequence of complexity parameters cp to compare using cross-validation, 
if \code{NULL} a sequence from 0 to 0.6 with stepsize 0.002 is used.}

\item{mc.cores}{Number of cores to use for parallel computation.}

\item{Q_scale}{Should data be scaled to estimate the spectral transformation? 
Default is \code{TRUE} to not reduce the signal of high variance covariates, 
and we do not know of a scenario where this hurts.}
}
\value{
A list containing
\item{cp_min}{The optimal complexity parameter.}
\item{cp_table}{A table containing the complexity parameter, 
the mean and the standard deviation of the loss on the validation sets for the 
complexity parameters. If multiple complexity parameters result in the same loss, 
only the one with the largest complexity parameter is shown.}
}
\description{
Estimates the optimal complexity parameter for the SDTree using cross-validation. 
The transformations are estimated for each training set and validation set 
separately to ensure independence of the validation set.
}
\examples{
set.seed(1)
n <- 50
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n, 0, 5)
cp <- cvSDTree(x = X, y = y, Q_type = 'no_deconfounding')
cp
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{SDTree}} \code{\link{prune.SDTree}} \code{\link{regPath.SDTree}}
}
\author{
Markus Ulmer
}
