% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markers_functions.R
\name{select_top_markers}
\alias{select_top_markers}
\title{select_top_markers}
\usage{
select_top_markers(
  selected_stages,
  cluster_vivo,
  norm_vivo,
  markers_small,
  max_number = 100,
  threshold = 0.1
)
}
\arguments{
\item{selected_stages}{Character vector with the name of the selected in vivo stages}

\item{cluster_vivo}{cluster for in vivo dataset}

\item{norm_vivo}{Norm count matrix (n_genes X n_cells) for in vivo dataset}

\item{markers_small}{Output given by the function \emph{markers_cluster_seurat} of the package CIARA}

\item{max_number}{Numeric value. Maximum number of top markers to consider for each stage in \emph{selected_stages}}

\item{threshold}{Numeric value.}
}
\value{
A list with two elements:

\item{marker_all}{Vector with the union of all the \emph{top_number} markers for each stage in \emph{selected_stages}}
\item{marker_stages}{List with length equal to number of stages in \emph{selected_stages} . Each element contains the \emph{top_number} markers for a given stage in \emph{selected_stages}  }
}
\description{
For each stage in \emph{selected_stages}, starting from the markers given by \emph{markers_cluster_seurat} function of the package CIARA, only the markers
with a median above \emph{threshold} in the stage and below \emph{threshold} in all the other stages are kept.
}
\seealso{
\url{ https://CRAN.R-project.org/package=CIARA}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
