% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_exists.R
\name{table_exists}
\alias{table_exists}
\alias{table_exists.DBIConnection}
\title{Test if a table exists in database}
\usage{
table_exists(conn, db_table)

\method{table_exists}{DBIConnection}(conn, db_table)
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{db_table}{(\verb{id-like object(1)})\cr
A table specification (coercible by \code{id()}).}
}
\value{
\code{TRUE} if db_table can be parsed to a table found in \code{conn}.
}
\description{
This functions attempts to determine the existence of a given table.
If a character input is given, matching is done heuristically assuming a "schema.table" notation.
If no schema is implied in this case, the default schema is assumed.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  dplyr::copy_to(conn, mtcars, name = "mtcars", temporary = FALSE)
  dplyr::copy_to(conn, iris, name = "iris")

  table_exists(conn, "mtcars")    # TRUE
  table_exists(conn, "iris")      # FALSE
  table_exists(conn, "temp.iris") # TRUE

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
