% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-harmonized_data_evaluate.R
\name{data_proc_elem_evaluate}
\alias{data_proc_elem_evaluate}
\title{Generate an assessment report for Data Processing Elements}
\usage{
data_proc_elem_evaluate(data_proc_elem, taxonomy = NULL)
}
\arguments{
\item{data_proc_elem}{A Data Processing Elements object.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}
}
\value{
A list of data frames containing assessment reports.
}
\description{
Assesses the content and structure of a Data Processing Elements object and
generates reports of the results. This function can be used to evaluate data
structure, presence of specific fields, coherence across elements, and data
dictionary formats.
}
\details{
The Data Processing Elements specifies the input elements and processing algorithms
to generate harmonized variables in the DataSchema formats. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal//}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.
}
\examples{
{
# Use Rmonize_examples to run examples.
library(dplyr)

data_proc_elem <- Rmonize_examples$`Data_Processing_Elements_no_errors`

glimpse(data_proc_elem)
}

}
