% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fuzzycoco_fit}
\alias{predict.fuzzycoco_fit}
\title{predict the outcome on some input data using a fitted model}
\usage{
\method{predict}{fuzzycoco_fit}(object, x, verbose = FALSE, bin = TRUE, ...)
}
\arguments{
\item{object}{the fuzzycoco_fit object containing the fuzzy system to predict on}

\item{x}{the input data to use with the fuzzy system to predict the output}

\item{verbose}{whether to be verbose}

\item{bin}{whether to transform the output data into a binary response. Only applies to classification models.}

\item{...}{not used. Only for S3 generic consistency}
}
\value{
the predicted output data as a data frame
}
\description{
N.B: just a S3 method method wrapping the \code{\link[=predict_fuzzy_system]{predict_fuzzy_system()}} function
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
x <- mtcars[c("mpg", "hp", "wt")]
y <- mtcars["qsec"]
fit <- fit_xy(model, x, y, progress = FALSE)

y2 <- predict(fit, x)
}
