% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marggpd.R
\docType{methods}
\name{marggpd}
\alias{marggpd}
\title{Assessing the Marginal Tail Fits}
\usage{
marggpd(margdata, blocksize = 1, nboot = 250, alpha = 0.05)
}
\arguments{
\item{margdata}{An S4 object of class \code{margtransf.class}. See \code{\link{margtransf}} for more details.}

\item{blocksize}{Size of the blocks for the block bootstrap procedure. If \code{1} (default), then a standard bootstrap approach is applied.}

\item{nboot}{Number of bootstrap samples to be taken. Default is \code{250} samples.}

\item{alpha}{Significance level to compute the \mjeqn{(1-\alpha)}{}\% tolerance intervals. Default is \code{0.05}.}
}
\value{
An object of S4 class \code{marggpd.class}. This object returns the arguments of the function and an extra slot \code{marggpd} which is a list containing: 
\item{model}{A list containing the model quantiles for each variable.} 
\item{empirical}{A list containing the empirical quantiles for each variable.}
\item{lower}{A list containing the lower bounds of the tolerance intervals for each variable.}
\item{upper}{A list containing the upper bounds of the tolerance intervals for each variable.}
}
\description{
\loadmathjax{}
Assessment of the marginal tail fits for each margin following the marginal transformation procedure \code{\link{margtransf}}.
}
\details{
Let \mjeqn{X^{GPD}_{(i)}}{} denote the \mjeqn{i}{i}-th ordered increasing statistic 
\mjeqn{(i = 1, \ldots, n)}{} of the exceedances, i.e., \mjeqn{X^{GPD}= (X-u \mid X >u),}{} 
\mjeqn{n_{exc}}{} denote the sample size of these exceedances, and \mjeqn{F_{GPD}^{-1}}{} denote the 
inverse of the cumulative distribution function of a generalised Pareto distribution (GPD).
Function \code{plot} shows QQ plots between the model and empirical GPD quantiles for both variables, i.e, for 
the first variable points \mjeqn{\left(F^{-1}_{GPD}\left(\frac{i}{n_{exc}+1}\right) + u, X^{GPD}_{(i)} + u\right)}{}, 
along with the line \mjeqn{y=x}{}. 

Uncertainty on the empirical quantiles is obtained via a (block) bootstrap procedure and shown by the grey region on the plot.
A good fit is shown by agreement of model and empirical quantiles, i.e. points should lie close to the line \mjeqn{y=x}{}. 
In addition, line \mjeqn{y = x}{} should mainly lie within the \mjeqn{(1-\alpha)}{}\% tolerance intervals.
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

margdata <- margtransf(airdata)

# blocksize to account for temporal dependence
marggpd <- marggpd(margdata = margdata, blocksize = 10)

plot(marggpd)

# To see the the S4 object's slots
str(marggpd)

# To access the list of lists
marggpd@marggpd

}
