% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rga.R
\name{plot.rga}
\alias{plot.rga}
\title{Plot Method for RGA Objects}
\usage{
\method{plot}{rga}(
  x,
  conf_bounds = TRUE,
  legend = TRUE,
  log = FALSE,
  legend_pos = "bottomright",
  ...
)
}
\arguments{
\item{x}{An object of class \code{rga}, which contains the results from the RGA model.}

\item{conf_bounds}{Logical; include confidence bounds (default: TRUE).}

\item{legend}{Logical; show the legend (default: TRUE).}

\item{log}{Logical; use a log-log scale (default: FALSE).}

\item{legend_pos}{Position of the legend (default: "bottomright").}

\item{...}{Additional arguments passed to \code{plot()}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
This function generates plots for objects of class \code{rga}.
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
result <- rga(times, failures)
plot(result,
  main = "Reliability Growth Analysis",
  xlab = "Cumulative Time", ylab = "Cumulative Failures"
)
}
\seealso{
Other Reliability Growth Analysis: 
\code{\link{print.rga}()},
\code{\link{rga}()}
}
\concept{Reliability Growth Analysis}
