#' Finding the two smallest values for each row of a matrix
#'
#' This function finds the two smallest values for each row of a matrix \code{matriz}.
#'
#' @param matriz Matrix
#'
#' @return Returns a matrix. The row i contains the two minimum values of the row i of the matrix \code{matriz}. The first column of the matriz contains the smallest value.
#' @examples
#'
#'
#'ma=rbind(c(5,4,3,2,1), c(10,9,8,7,6), c(120,119,103,104,105))
#'DosMinimos(ma)
#' @export
#'
#'







DosMinimos<-function(matriz){
  dos_menores=matrix(0,nrow(matriz),2)
  for (i in 1:nrow(matriz)) {
    dos_menores[i,] <- sort(matriz[i, ])[c(1,2)]
  }

  return(dos_menores)
}
