% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dRW.R
\name{dRW}
\alias{dRW}
\alias{pRW}
\alias{qRW}
\alias{rRW}
\alias{hRW}
\title{The Reflected Weibull distribution}
\usage{
dRW(x, mu, sigma, log = FALSE)

pRW(q, mu, sigma, lower.tail = TRUE, log.p = FALSE)

qRW(p, mu, sigma, lower.tail = TRUE, log.p = FALSE)

rRW(n, mu, sigma)

hRW(x, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dRW} gives the density, \code{pRW} gives the distribution 
function, \code{qRW} gives the quantile function, \code{rRW}
generates random deviates and \code{hRW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Reflected Weibull Distribution 
with parameters \code{mu} and \code{sigma}.
}
\details{
The Reflected Weibull Distribution with parameters \code{mu} 
and \code{sigma} has density given by

\eqn{f(y) = \mu\sigma (-y) ^{\sigma - 1} e ^ {-\mu(-y)^\sigma},}

for y < 0.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dRW(x, mu=1, sigma=1), from=-5, to=-0.01,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pRW(x, mu=1, sigma=1),
      from=-5, to=-0.01, col="red", las=1, ylab="F(x)")
curve(pRW(x, mu=1, sigma=1, lower.tail=FALSE),
      from=-5, to=-0.01, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qRW(p, mu=1, sigma=1), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pRW(x, mu=1, sigma=1), from=-5, add=TRUE, col="red")

## The random function
hist(rRW(n=10000, mu=1, sigma=1), freq=FALSE,
     xlab="x", las=1, main="")
curve(dRW(x, mu=1, sigma=1), from=-5, to=-0.01, add=TRUE, col="red")

## The Hazard function
par(mfrow=c(1,1))
curve(hRW(x, mu=1, sigma=1), from=-0.3, to=-0.01,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{Clifford1973}{RelDists}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
