% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEGG.R
\name{dEGG}
\alias{dEGG}
\alias{pEGG}
\alias{qEGG}
\alias{rEGG}
\alias{hEGG}
\title{The four parameter Exponentiated Generalized Gamma distribution}
\usage{
dEGG(x, mu, sigma, nu, tau, log = FALSE)

pEGG(q, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

qEGG(p, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

rEGG(n, mu, sigma, nu, tau)

hEGG(x, mu, sigma, nu, tau)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{tau}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dEGG} gives the density, \code{pEGG} gives the distribution 
function, \code{qEGG} gives the quantile function, \code{rEGG}
generates random deviates and \code{hEGG} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the four parameter Exponentiated Generalized Gamma distribution
with parameters \code{mu}, \code{sigma}, \code{nu} and \code{tau}.
}
\details{
Four-Parameter Exponentiated Generalized Gamma distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x) = \frac{\nu \sigma}{\mu \Gamma(\tau)} \left(\frac{x}{\mu}\right)^{\sigma \tau -1} \exp\left\{ - \left( \frac{x}{\mu} \right)^\sigma \right\} \left\{ \gamma_1\left( \tau, \left( \frac{x}{\mu} \right)^\sigma \right) \right\}^{\nu-1} ,}

for x > 0.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dEGG(x, mu=0.1, sigma=0.8, nu=10, tau=1.5), from=0.000001, to=1.5, ylim=c(0, 2.5),
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pEGG(x, mu=0.1, sigma=0.8, nu=10, tau=1.5),
      from=0.000001, to=1.5, col="red", las=1, ylab="F(x)")
curve(pEGG(x, mu=0.1, sigma=0.8, nu=10, tau=1.5, lower.tail=FALSE),
      from=0.000001, to=1.5, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qEGG(p, mu=0.1, sigma=0.8, nu=10, tau=1.5), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pEGG(x, mu=0.1, sigma=0.8, nu=10, tau=1.5), 
      from=0.00001, add=TRUE, col="red")

## The random function
hist(rEGG(n=100, mu=0.1, sigma=0.8, nu=10, tau=1.5), freq=FALSE,
     xlab="x", las=1, main="")
curve(dEGG(x, mu=0.1, sigma=0.8, nu=10, tau=1.5),
      from=0.0001, to=2, add=TRUE, col="red")

## The Hazard function
curve(hEGG(x,  mu=0.1, sigma=0.8, nu=10, tau=1.5), from=0.0001, to=1.5,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{cordeiro2011}{RelDists}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
