% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/things.R
\name{things}
\alias{things}
\alias{things_create}
\alias{things_update}
\alias{things_list}
\alias{things_show}
\alias{things_delete}
\title{Things API methods}
\usage{
things_create(
  device_id = NULL,
  thing_id = NULL,
  name = NULL,
  properties = NULL,
  timezone = NULL,
  force = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_update(
  device_id = NULL,
  thing_id = NULL,
  name = NULL,
  properties = NULL,
  timezone = NULL,
  force = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_list(
  device_id = NULL,
  thing_id = NULL,
  show_deleted = FALSE,
  show_properties = FALSE,
  tags = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_show(
  thing_id,
  show_deleted = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

things_delete(
  thing_id,
  force = FALSE,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{device_id}{The id of the device (The arn of the associated device)}

\item{thing_id}{The id of the thing}

\item{name}{The friendly name of the thing}

\item{properties}{A tibble with the following columns (see \code{things_properties_create})
\itemize{
\item \code{name} (required) The friendly name of the property
\item \code{permission} (required) The permission of the property (READ_ONLY or READ_WRITE allowed)
\item \code{type} (required) The type of the property (see details for exhaustive list of values)
\item \code{update_strategy} (required) The update strategy for the property value (ON_CHANGE or TIMED allowed)
\item \code{max_value} (optional, numeric) Maximum value of this property
\item \code{min_value} (optional, numeric) Minimum value of this property
\item \code{persist} (optional, logic) If \code{TRUE}, data will persist into a timeseries database
\item \code{tag} (optional, numeric) The integer id of the property
\item \code{update_parameter} (optional, numeric) The update frequency in seconds, or the amount of the property
has to change in order to trigger an update
\item \code{variable_name} (character) The sketch variable name of the property
}}

\item{timezone}{A time zone name. Check \code{get_timezone} for a list of valid names. (default: America/New_York)}

\item{force}{(logical)  If \code{TRUE}, detach device from the other thing, and attach to this thing.
In case of deletion, if \code{TRUE}, hard delete the thing. Default to \code{FALSE}}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session)}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}.}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}

\item{show_deleted}{(logical) If \code{TRUE}, shows the soft deleted things. Default to \code{FALSE}}

\item{show_properties}{(logical) If \code{TRUE}, returns things with their properties, and last values. Default to \code{FALSE}}

\item{tags}{tags you  may want to filter from the list}
}
\value{
A tibble showing information about chosen thing or list of thing for current user
}
\description{
Create, Update, List, Show and Delete properties associated to a given thing

Official documentation:
\itemize{
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2Create}{thingsV2Create}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2Update}{thingsV2Update}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2List}{thingsV2List}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2Show}{thingsV2Show}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-ThingsV2-thingsV2Delete}{thingsV2Delete}
}
}
\examples{
\dontrun{
library(dplyr)

# Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
# Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')
create_auth_token()

### create thing ###
things_create(name = "test")

### check things list ###
t_list = things_list(silent = TRUE)
thing_id = t_list \%>\% filter(name == "test") \%>\% pull(id)

things_show(thing_id = thing_id)

### update thing ###
properties = tibble(name = c("test1", "test2"),
permission = rep("READ_ONLY", 2), type = rep("FLOAT", 2),
update_strategy = rep("ON_CHANGE", 2), update_parameter = rep(10, 2))

things_update(thing_id = thing_id, name = "test_update", properties = properties)

### delete thing ###
things_delete(thing_id = thing_id)
}
}
