# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This function uses the Boost Date_Time library to parse 
#' datetimes (and dates) from strings, integers or even numeric values
#' (which are cast to strings internall). It returns a vector of
#' \code{POSIXct} objects. These represent dates and time as (possibly
#' fractional) seconds since the \sQuote{epoch} of January 1, 1970. 
#' A timezone can be set, if none is supplied \sQuote{UTC} is set.
#'
#' A number of fixed formats are tried in succession. These include
#' the standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS} as well as
#' different local variants including several forms popular in the 
#' United States.  Two-digits years and clearly ambigous formats such
#' as \sQuote{03/04/05} are ignored.  In the case of parsing failure
#' a \code{NA} value is returned.
#'
#' Fractional seconds are supported as well.  As R itself only supports 
#' microseconds, the Boost compile-time option for nano-second resolution 
#' has not been enabled.
#'
#' @title Parse POSIXct objects from input data
#' @param x A vector of type character, integer or numeric with 
#' date(time) expressions to be parsed and converted. 
#' @param tz A string with the timezone, defaults to \sQuote{UTC} if unset
#' @return A vector of \sQuote{POSIXct} elements.
#' @seealso The funtion in the anytime package which is a more finished.
#' variant which is based on the initial work with function, and taken into
#' its own package.
#' @author Dirk Eddelbuettel
#' @examples
#' ## See the source code (hah!) for a full list of formats
#' times <- c("2004-03-21 12:45:33.123456",
#'           "2004/03/21 12:45:33.123456",
#'           "20040321 124533.123456",
#'           "21.03.2004 12:45:33.123456", 
#'           "03/21/2004 12:45:33.123456",
#'           "03-21-2004 12:45:33.123456", 
#'           "2004-03-21",
#'           "20040321",
#'           "03/21/2004",
#'           "03-21-2004",
#'           "20010101")   
#' toPOSIXct(times)
toPOSIXct <- function(x, tz = "UTC") {
    .Call(`_RcppBDT_toPOSIXct`, x, tz)
}

#' This function uses the Boost Date_Time library to parse 
#' datetimes from strings. It returns a vector of \code{POSIXct}
#' objects. These represent dates and time as (possibly
#' fractional) seconds since the \sQuote{epoch} of January 1, 1970. 
#' A timezone can be set, if none is supplied \sQuote{UTC} is set.
#'
#' A single standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS} (with
#' optional trailing fractional seconds) is tried.  In the case of
#' parsing failure a \code{NA} value is returned. See the function
#' \code{\link{toPOSIXct}} for more general input format
#'
#' Fractional seconds are supported as well.  As R itself only supports 
#' microseconds, the Boost compile-time option for nano-second resolution 
#' has not been enabled.
#'
#' @title Parse POSIXct objects from character variables
#' @param sv A vector of type character with datetime expressions
#' in ISO format to be parsed and converted. 
#' @param tz A string with the timezone, defaults to \sQuote{UTC} if unset
#' @return A vector of \sQuote{POSIXct} elements.
#' @author Dirk Eddelbuettel
#' @examples
#' times <- c("2004-03-21 12:45:33.123456",
#'           "2004-03-21 12:45:34")
#' charToPOSIXct(times)
charToPOSIXct <- function(sv, tz = "UTC") {
    .Call(`_RcppBDT_charToPOSIXct`, sv, tz)
}

#' This function uses Rcpp to parse
#' datetimes from strings. It returns a vector of \code{POSIXct}
#' objects. These represent dates and time as (possibly
#' fractional) seconds since the \sQuote{epoch} of January 1, 1970.
#' A timezone can be set, if none is supplied \sQuote{UTC} is set.
#'
#' The default standard ISO format \sQuote{YYYY-MM-DD HH:MM:SS.FFFFFFF} is
#' is used by default along with the UTC time zone.
#'
#' This function is for comparison only.
#'
#' @title Parse POSIXct objects from character variables
#' @param sv A vector of type character with datetime expressions
#' in ISO format to be parsed and converted.
#' @param fmt A format, defaults to the ISO format if unset
#' @param tz A string with the timezone, defaults to \sQuote{UTC} if unset
#' @return A vector of \sQuote{POSIXct} elements.
#' @seealso \code{\link[Rcpp]{Rcpp}}
#' @author Dirk Eddelbuettel
#' @examples
#' times <- c("2004-03-21 12:45:33.123456",
#'           "2004-03-21 12:45:34")
#' cToPOSIXct(times)
cToPOSIXct <- function(sv, fmt = "%Y-%m-%d %H:%M:%OS", tz = "UTC") {
    .Call(`_RcppBDT_cToPOSIXct`, sv, fmt, tz)
}

