% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dynamics.R
\name{Michaelis.Menten.Fast}
\alias{Michaelis.Menten.Fast}
\title{Optimized Michaelis-Menten equations}
\usage{
Michaelis.Menten.Fast(t, x, params)
}
\arguments{
\item{t}{Current time}

\item{x}{Current value of all nodes}

\item{params}{List of parameters. Should include the B_eff matrix of the network as `Beta`, and parameters `f, h,` and `B`. To understand how to construct the matrix B_eff, please refer to the Barabasi paper.}
}
\value{
A list with `dx`
}
\description{
The optimized Michaelis-Menten equations described by Barabasi in his paper 'Universal resilience patterns in complex networks'.
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
 
   initial_parameters <- function(M){
     initial_params <- list('f' = 1, 'h' = 2, 'B' = 0.1, 'Beta' = Rato::Barabasi.B_eff(M))
     return(initial_params)
   }
   
   update_parameters <- function(params){
     M <- params$M
     params$Beta <- Rato::Barabasi.B_eff(M)
     return(params)
   }
 
   Rato::node.removal.thread( system = Rato::Michaelis.Menten.Fast
                            , M = g$M
                            , x0 = Rato::Barabasi.X_eff(g$M, g$initial_values)
                            , initial_params = initial_parameters
                            , update_params = update_parameters
                            , to.numeric = TRUE)

}
}
