% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_diagnostics_triangulation_blobs.R
\name{triangulationBlobs}
\alias{triangulationBlobs}
\title{Calculate triangulation blobs data for an antigenic map}
\usage{
triangulationBlobs(
  map,
  optimization_number = 1,
  stress_lim = 1,
  grid_spacing = 0.25,
  antigens = TRUE,
  sera = TRUE,
  .check_relaxation = TRUE,
  .options = list()
)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The optimization number to check}

\item{stress_lim}{The blob stress limit}

\item{grid_spacing}{Grid spacing to use when searching map space and
inferring the blob}

\item{antigens}{Should triangulation blobs be calculated for antigens}

\item{sera}{Should triangulation blobs be calculated for sera}

\item{.check_relaxation}{Should a check be performed that the map is fully
relaxed (all points in a local optima) before the search is performed}

\item{.options}{List of named optimizer options to use when checking map
relaxation, see \code{RacOptimizer.options()}}
}
\value{
Returns the acmap data object with triangulation blob information added,
which will be shown when the map is plotted
}
\description{
This function is to help give an idea of how well coordinated each point is
in a map, and to give some idea of uncertainty in it's position. It works
by moving each point in a grid search and seeing how the total map stress
changes, see details.
}
\details{
The region or regions of the plot where total map stress is not
increased above a certain threshold (\code{stress_lim}) are shown when the map
is plotted. This function is really to check whether point positions are
clearly very uncertain, for example the underlying titers may support an
antigen being a certain distance away from a group of other points but due
to the positions of the sera against which it was titrated the direction
would be unclear, and you might see a blob that forms an arc or "banana"
that represents this. Note that it is not really a confidence interval
since a point may be well coordinated in terms of the optimization but
it's position may still be defined by perhaps only one particular titer
which is itself uncertain. For something more akin to confidence intervals
you can use other diagnostic functions like \code{bootstrapMap()}.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
