% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{distance.matrix.true.tree}
\alias{distance.matrix.true.tree}
\title{Calculates distance matrix for a synthetized data}
\usage{
distance.matrix.true.tree(D, normalize = TRUE)
}
\arguments{
\item{D}{Output of synthesis function}

\item{normalize}{If true, sum of all elements of resulting
table is added up to one.}
}
\value{
The distance matrix of the true tree.
}
\description{
Calculates distance matrix for a synthetized data
}
\examples{
## Synthesise an evolution
S = synthesis(10, 5, 20, seed=7)
## Calculating the distance matrix of the true tree.
distance.matrix.true.tree(S)
#              C3          C6          C4          C2          C7
# C3  0.000000000 0.004587156 0.006880734 0.009174312 0.013761468
# C6  0.004587156 0.000000000 0.002293578 0.009174312 0.013761468
# C4  0.006880734 0.002293578 0.000000000 0.011467890 0.016055046
# C2  0.009174312 0.009174312 0.011467890 0.000000000 0.004587156
# C7  0.013761468 0.013761468 0.016055046 0.004587156 0.000000000
# C10 0.006880734 0.006880734 0.009174312 0.011467890 0.016055046
# C8  0.006880734 0.011467890 0.013761468 0.016055046 0.020642202
# C9  0.006880734 0.011467890 0.013761468 0.016055046 0.020642202
# C1  0.011467890 0.011467890 0.013761468 0.002293578 0.006880734
# C5  0.011467890 0.011467890 0.013761468 0.002293578 0.006880734
# C10          C8          C9          C1          C5
# C3  0.006880734 0.006880734 0.006880734 0.011467890 0.011467890
# C6  0.006880734 0.011467890 0.011467890 0.011467890 0.011467890
# C4  0.009174312 0.013761468 0.013761468 0.013761468 0.013761468
# C2  0.011467890 0.016055046 0.016055046 0.002293578 0.002293578
# C7  0.016055046 0.020642202 0.020642202 0.006880734 0.006880734
# C10 0.000000000 0.013761468 0.013761468 0.013761468 0.013761468
# C8  0.013761468 0.000000000 0.000000000 0.018348624 0.018348624
# C9  0.013761468 0.000000000 0.000000000 0.018348624 0.018348624
# C1  0.013761468 0.018348624 0.018348624 0.000000000 0.000000000
# C5  0.013761468 0.018348624 0.018348624 0.000000000 0.000000000

}
