% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLegend.R
\name{plotLegend}
\alias{plotLegend}
\title{Plot legend for colored mesh.}
\usage{
plotLegend(mesh,values,main)
}
\arguments{
\item{mesh}{a \code{mesh3d} object}

\item{values}{a vector of continuous values associated to individual vertices
of the \code{mesh}.}

\item{main}{plot title.}
}
\value{
A plot of the color sequence associated to \code{values} on the \code{mesh}.
}
\description{
Assuming a \code{mesh} is colored according to a vector of \code{values},
  the function takes the color sequence from the \code{mesh} and plots it
  associated to \code{values}.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(rgl)
  require(Morpho)
  require(Rvcg)

  pca<-procSym(endo.set)
  ldm<-endo.set[,,"Homo_sapiens"]
  sur<-endo.sur[["Homo_sapiens"]]

  rec<- vcgBallPivoting(pca$mshape, radius = 0)
  rec$vb[1:3,]<-t(ldm)
  val<-rnorm(ncol(rec$vb))

  interp<-interpolMesh(sur = rec,refsur = sur,refmat = ldm,
                       values = val,element ="vertices",k = 4)

  colmesh<-col2mesh(mesh = sur,values = interp,pal = heat.colors(5))
  plotLegend(mesh = colmesh,values = interp, main = "Pan troglodytes")
  open3d()
  shade3d(colmesh,specular="black")
  }
}
\author{
Marina Melchionna, Silvia Castiglione
}
