% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{add_fpr_threshold_line}
\alias{add_fpr_threshold_line}
\alias{add_tpr_threshold_line}
\alias{plot_thresholds}
\alias{add_threshold_line}
\title{Add a threshold line to a ROC plot}
\usage{
add_fpr_threshold_line(threshold)

add_tpr_threshold_line(threshold)

add_threshold_line(threshold, ratio = NULL)
}
\arguments{
\item{threshold}{A number between 0 and 1, both inclusive, which represents
the region bound where to calculate partial area under curve.

If \code{ratio = "tpr"}, it represents lower bound of the TPR region, being its
upper limit equal to 1.

If \code{ratio = "fpr"}, it represents the upper bound of the FPR region,
being its lower limit equal to 0.}

\item{ratio}{Ratio in which to display threshold.
\itemize{
\item If \code{"tpr"} threshold will be displayed in TPR, y axis
\item If \code{"fpr"} it will be displayed in FPR, x axis.
}}
}
\value{
A ggplot layer instance object.
}
\description{
Include a threshold line on an specified axis.
}
\examples{
# Add two threshold line in TPR = 0.9 and FPR = 0.1
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
 add_threshold_line(threshold = 0.9, ratio = "tpr") +
 add_threshold_line(threshold = 0.1, ratio = "fpr")
# Add threshold line in TPR = 0.9
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
 add_tpr_threshold_line(threshold = 0.9)
# Add threshold line in FPR = 0.1
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
 add_fpr_threshold_line(threshold = 0.1)
}
