% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_kernels.R
\name{SparseLuMicrobenchmark}
\alias{SparseLuMicrobenchmark}
\title{Conducts a single performance trial with the LU factorization sparse matrix
kernel}
\usage{
SparseLuMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{SparseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the sparse matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the sparse matrix kernel}
}
\description{
\code{SparseMatrixVectorMicrobenchmark} conducts a single performance trial
of the Cholesky factorization sparse matrix kernel for the matrix given
in the \code{kernelParameters} parameter.  The function times the single
function
call \code{kernelParameters$A \%*\% kernelParameters$b}.
}
\examples{
\dontrun{
# Allocate input to the LU factorization microbenchmark for the
# circuit5M_dc matrix
microbenchmarks <- GetSparseLuDefaultMicrobenchmarks()
kernelParameters <- SparseLuAllocator(microbenchmarks[["lu_circuit5M_dc"]], 1)
# Execute the microbenchmark
timings <- SparseLuMicrobenchmark(
   microbenchmarks[["lu_circuit5M_dc"]], kernelParameters)
}

}
