% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_match_history.R
\name{get_match_history}
\alias{get_match_history}
\title{A list of Matches}
\usage{
get_match_history(hero_id = NULL, game_mode = NULL, skill = NULL,
  date_min = NULL, date_max = NULL, min_players = NULL,
  account_id = NULL, league_id = NULL, start_at_match_id = NULL,
  matches_requested = NULL, tournament_games_only = NULL, tz = "",
  dota_id = 570, language = "en", key = NULL)
}
\arguments{
\item{hero_id}{(optional) The hero id. A list of hero ids can be found
via the get_heroes function.}

\item{game_mode}{(optional) The game mode:
\itemize{
  \item 0 - None
  \item 1 - All Pick
  \item 2 - Captain's Mode
  \item 3 - Random Draft
  \item 4 - Single Draft
  \item 5 - All Random
  \item 6 - Intro
  \item 7 - Diretide
  \item 8 - Reverse Captain's Mode
  \item 9 - The Greeviling
  \item 10 - Tutorial
  \item 11 - Mid Only
  \item 12 - Least Played
  \item 13 - New Player Pool
  \item 14 - Compendium Matchmaking
  \item 16 - Captain's Draft
}
No 15 does not exist}

\item{skill}{(optional) Skill bracket.
\itemize{
\item 0 - Any
\item 1 - Normal
\item 2 - High
\item 3 - Very High
}}

\item{date_min}{(optional) Minimum date range for returned matches (yyyy-mm-dd HH:MM:SS).}

\item{date_max}{(optional) Maximum date range for returned matches (yyyy-mm-dd HH:MM:SS).}

\item{min_players}{(optional) Minimum number of players in match.}

\item{account_id}{(optional) Account ID.}

\item{league_id}{(optional) League ID.}

\item{start_at_match_id}{(optional) Matches equal or older than this ID.}

\item{matches_requested}{(optional) Amount of matches to return (defaults to 25).}

\item{tournament_games_only}{(optional) Binary (0 or 1). Whether to return tournament matches.}

\item{tz}{A time zone specification if date_min and/or date_max are used. See
\link{as.POSIXct}. "" (default) is the current time zone and "GMT" is UTC.}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
A list of matches based on various parameters.
}
\details{
A list will be returned that contains three elements. The content, the url and the
response received from the api.

The content element of the list contains a list called matches.
Each element of matches list is a match. Each match contains
the following sections:

\itemize{
  \item \strong{match_id:} The match id.
  \item \strong{match_seq_num:}A sequence number, representing the order in which
  matches were recorded.
  \item \strong{start_time:} UNIX timestamp of when the game began.
  \item \strong{lobby_type:} Check the API Documentation.
  \item \strong{radiant_team_id:} Radiant team id.
  \item \strong{dire_team_id:} Dire team id.
  \item \strong{players:} A list containing information about the players.
}
}
\section{Steam API Documentation}{

\url{https://wiki.teamfortress.com/wiki/WebAPI/GetMatchHistory}
}
\examples{
\dontrun{
get_match_history(matches_requested = 2)
get_match_history(matches_requested = 2, date_min = '2015-01-01 16:00:00', hero_id = 1)
get_match_history(language = 'en', key = NULL)
get_match_history(language = 'en', key = 'xxxxxxxxxxx')
}

}

