% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{pcrFormatType}
\alias{pcrFormatType}
\title{pcrFormatType R6 class.}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
The display format of the PCR, analogous to the the qPCR instrument run format.
Inherits: \link{rdmlBaseType}.
}
\details{
Rotor formats always have 1 column; rows correspond to the number of places
in the rotor. Values for common formats are: \tabular{lllll}{ Format \tab
rows \tab columns \tab rowLabel \tab columnLabel \cr single-well \tab 1
\tab 1       \tab 123      \tab 123         \cr 48-well plate \tab 6    \tab
8       \tab ABC      \tab 123         \cr 96-well plate \tab 8    \tab 12
\tab ABC      \tab 123         \cr 384-well plate \tab 16   \tab 24      \tab
ABC      \tab 123         \cr 1536-well plate \tab 32   \tab 48      \tab ABC
\tab 123         \cr 3072-well array \tab 32   \tab 96      \tab A1a1
\tab A1a1        \cr 5184-well chip \tab 72   \tab 72      \tab ABC      \tab
123         \cr 32-well rotor \tab 32   \tab 1       \tab 123      \tab 123
\cr 72-well rotor \tab 72   \tab 1       \tab 123      \tab 123         \cr
100-well rotor \tab 100  \tab 1       \tab 123      \tab 123         \cr free
format \tab -1   \tab 1       \tab 123      \tab 123 } If rows field has value -1,
the function will not try to reconstruct a plate and just display all run
data in a single column. If the columns field has value 1 then the function will
not display a column label.
}
\section{Initialization}{
 \preformatted{pcrFormatType$new(rows, columns, rowLabel, columnLabel)}

  @section Fields: \describe{
\item{\code{rows}}{\link[checkmate]{checkCount}.}
\item{\code{columns}}{\link[checkmate]{checkCount}.}
\item{\code{rowLabel}}{\link{labelFormatType}.}
\item{\code{columnLabel}}{\link{labelFormatType}.}
  }
}

\section{Super class}{
\code{\link[RDML:rdmlBaseType]{RDML::rdmlBaseType}} -> \code{pcrFormatType}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pcrFormatType-new}{\code{pcrFormatType$new()}}
\item \href{#method-pcrFormatType-clone}{\code{pcrFormatType$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id=".asXMLnodes"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-.asXMLnodes'><code>RDML::rdmlBaseType$.asXMLnodes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="copy"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-copy'><code>RDML::rdmlBaseType$copy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="print"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-print'><code>RDML::rdmlBaseType$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pcrFormatType-new"></a>}}
\if{latex}{\out{\hypertarget{method-pcrFormatType-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pcrFormatType$new(rows, columns, rowLabel, columnLabel)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pcrFormatType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pcrFormatType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pcrFormatType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
