% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{get_pedigree_table}
\alias{get_pedigree_table}
\title{Get the Pedigree Table}
\usage{
get_pedigree_table(
  data,
  geno_column = "germplasmName",
  pedigree_column = "pedigree"
)
}
\arguments{
\item{data}{A data frame containing genotype/germplasm data, including names and pedigree strings.}

\item{geno_column}{The name of the column that identifies the genotype/germplasm names.}

\item{pedigree_column}{The name of the column that contains the pedigree strings.}
}
\value{
A data frame with three columns:
  - `Variety`: The identifier for the individual genotype.
  - `Female`: The identifier for the female parent.
  - `Male`: The identifier for the male parent.
The pedigree table is sorted such that individuals appear before any row where they are listed as a parent.
For founders (i.e., individuals with no parent information), `NA` is used for the parental columns.
}
\description{
Retrieves a comprehensive pedigree table for the given dataset, which contains genotype names and pedigree strings. 
The function recursively traces parentage across generations and builds a pedigree table where each row corresponds 
to an individual, with columns for the female and male parents. It also handles cases of similar genotype names 
by standardizing them.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  set_trial("IDYT39")
  set_study("IDYT39 Environment Number 9")
  germplasm <- get_germplasm_list()
  pedigree_table <- get_pedigree_table(germplasm, "germplasmName", "pedigree")

  #############################
  # nadiv package way
  # library(nadiv)

  # Get additive relationship matrix in sparse matrix format
  # A <- nadiv::makeA(pedigree_table)

  # Get A inverse matrix using base R function
  # AINV <- solve(as.matrix(A))

  #############################
  # ASReml-R package way
  # library(asreml)

  # Represent A inverse matrix in an efficient way using i, j index and Ainverse value
  # Actual genotype names of any given index are in the attr(ainv, "rowNames")
  # ainv <- asreml::ainverse(pedigree_table)

  #############################
  # Dummy data set for testing
  test <- data.frame(genotype = c("X", "Y"),
                     pedigree = c("A//B/D/2/C", "B/C/3/A//B/C/2/D"))

  pedigree_table <- get_pedigree_table(test, "genotype", "pedigree")
}

}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
