% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_data.R
\docType{data}
\name{nhl_data}
\alias{nhl_data}
\title{NHL Draft Data}
\format{
A \code{tibble} with the following columns:
\describe{
  \item{\code{source}}{The source of the data.}
  \item{\code{name}}{The name of the player.}
  \item{\code{year}}{The year of the draft.}
  \item{\code{rank}}{The rank of the player in the draft.}
  \item{\code{round}}{The round in which the player was drafted.}
  \item{\code{date_of_birth}}{The date of birth of the player.}
  \item{\code{age}}{The age of the player at the time of the draft.}
  \item{\code{current_team}}{The current team of the player.}
  \item{\code{league}}{The league the player was playing in before the draft.}
  \item{\code{scouting_report}}{A scouting report of the player.}
  \item{\code{team_fit}}{How well the player fits with the drafting team.}
  \item{\code{likely_to_play}}{The likelihood of the player playing in the NHL.}
  \item{\code{position}}{The position the player plays.}
  \item{\code{city}}{The city associated with the player or team.}
  \item{\code{team}}{The team that selected the player.}
  \item{\code{analysis}}{An analysis of the player's potential and performance.}
}
}
\usage{
nhl_data
}
\description{
A dataset of all first-round picks in the NHL, including various draft metrics.
}
\examples{
# Load the dataset
data(nhl_data)

# View the first few rows
head(nhl_data)

# Filter the data for players drafted in a specific year, e.g., 2023
nhl_2023 <- dplyr::filter(nhl_data, year == 2023)

# View the first few rows
head(nhl_2023)

# Filter the data to include only ESPN as the source
nhl_data |>
  dplyr::filter(source == "ESPN")

}
\keyword{datasets}
