% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{scores_oos_only}
\alias{scores_oos_only}
\title{Mask score tables to out-of-sample decision dates}
\usage{
scores_oos_only(scores_dt, weights_wide)
}
\arguments{
\item{scores_dt}{Wide table of model scores with columns \code{Date}, \code{SYM1},
\code{SYM2}, … (one column per symbol).}

\item{weights_wide}{Wide table of realised portfolio weights with columns
\code{Date}, \code{SYM1}, \code{SYM2}, … (one column per symbol). Decision dates are
inferred as rows where any symbol weight is non-zero.}
}
\value{
A copy of \code{scores_dt} where rows not matching decision dates are set to \code{NA}
(except the \code{Date} column). If either input is empty, returns \code{scores_dt[0]}.
}
\description{
Utility used in the chapter’s diagnostics: keep scores only on dates when a
portfolio decision was actually made (non-zero realised weights); set other
dates to \code{NA}. Inputs are wide by symbol with a \code{Date} column.
}
\examples{
# Toy example
dates <- as.Date("2020-01-01") + 7*(0:5)
scores <- data.frame(
  Date = dates,
  AAA = seq(0.1, 0.6, length.out = 6),
  BBB = rev(seq(0.1, 0.6, length.out = 6))
)
weights <- data.frame(
  Date = dates,
  AAA  = c(0, 0.1, 0, 0.2, 0, 0.15),
  BBB  = c(0, 0,   0, 0,   0, 0   )
)
scores_oos_only(scores, weights)

}
\seealso{
\code{\link[=pt_collect_results]{pt_collect_results()}}

Other Chapter3-helpers: 
\code{\link{pt_collect_results}()}
}
\concept{Chapter3-helpers}
