% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{constant}
\alias{constant}
\title{Constant specification model}
\usage{
constant(stateVariable, theta, ...)
}
\arguments{
\item{stateVariable}{state variable}

\item{theta}{parameter}

\item{...}{...}
}
\value{
numeric level
}
\description{
All specification models can be used as parameter in \code{\link{estimate.functional}}.
Specification models are used to denote the quantile or expectile level
(depending on the identification function).
The constant specification model returns the parameter theta irrespective of
the state variable. If theta is not in the unit interval, the constant specification
model returns 0 or 1 (depending on which is closer).
}
\examples{
# the returned level does not depend on the state variable
constant(0,.5)
constant(1,.5)

# if theta is not in the unit interval, the constant specification model forces it to be so
constant(0, 2)
constant(0, -1)
}
\seealso{
Other specification models: \code{\link{logistic_linear}},
  \code{\link{probit_break}}, \code{\link{probit_linear}},
  \code{\link{probit_spline2}},
  \code{\link{probit_spline3}}
}
\concept{specification models}
