% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WMFVST.R
\name{WMFVST}
\alias{WMFVST}
\title{Weighted Mean Membership Function Value for Stress Tolerance (WMFVST)}
\usage{
WMFVST(data)
}
\arguments{
\item{data}{A data frame containing genotype IDs (Gen) and MFVST values for the indices
(GMP, HM, MP, MRP, PYR, RSI, SSPI, STI, TOL, YI, YSI), each within the range of 0 to 1.}
}
\value{
A data frame with Gen and its Weighted Mean MFVST (WMFVST).
}
\description{
Its a composite measure which computes the weighted mean of MFVST values (0–1 range) for each genotype
across multiple stress indices, considering whether higher or lower values are better.
}
\details{
The Weighted Mean MFVST for genotype \emph{i} is:
\deqn{WMFVST_i = \frac{\sum_{j=1}^{k} (MFVST_{ij} \times R_{ij})}
                     {\sum_{j=1}^{k} R_{ij}}}
where \eqn{MFVST_{ij}} is the MFVST value of genotype \emph{i} for index \emph{j}, and
\eqn{R_{ij}} is its rank, determined by whether higher or lower values are favorable.
}
\examples{
set.seed(123)
df <- data.frame(
  Gen = paste0("G", 1:5),
  GMP  = runif(5),
  HM   = runif(5),
  MP   = runif(5),
  MRP  = runif(5),
  PYR  = runif(5),
  RSI  = runif(5),
  SSPI = runif(5),
  STI  = runif(5),
  TOL  = runif(5),
  YI   = runif(5),
  YSI  = runif(5)
)
WMFVST(df)
}
