% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{var}
\alias{var}
\alias{var.cont_phase_type}
\alias{var.disc_phase_type}
\alias{var.mult_cont_phase_type}
\alias{var.mult_disc_phase_type}
\title{Variance and Covariance of Phase-Type Distributions}
\usage{
var(obj, ...)

\method{var}{cont_phase_type}(obj, ...)

\method{var}{disc_phase_type}(obj, ...)

\method{var}{mult_cont_phase_type}(obj, v = NULL, ...)

\method{var}{mult_disc_phase_type}(obj, v = NULL, ...)
}
\arguments{
\item{obj}{a \code{cont_phase_type}, \code{disc_phase_type},
\code{mult_cont_phase_type} or \code{mult_disc_phase_type} object}

\item{...}{other arguments passed to methods}

\item{v}{NULL, integer or vector of length 2.}
}
\value{
The value returned is either the variance (for univariate
distributions) or the variance-covariance matrix (for multivariate distributions).
}
\description{
Calculates the (co)variance of continuous, discrete and multivariate phase-type
distributions generated by \code{PH}, \code{DPH}, \code{MPH} and  \code{MDPH}.
}
\details{
For  the univariate case (\code{cont_phase_type} and \code{disc_phase_type}),
the variance of the distribution is returned.

In the case of multivariate phase-type distributions three
different usages can be distinguished:
\itemize{
 \item{If \code{v = NULL} (default), then a variance-covariance matrix of all
 the variables specified in the reward matrix are returned, where variances
 are in the diagonal and covariances in the rest of the matrix element.}
 \item{If \code{v} is an integer, then the variance of the variable encoded
 by the \code{v} index in the reward matrix is returned.}
 \item{If \code{v} is a vector of length 2, then the covariance between the
 two variables encoded by the \code{v} indices in the reward matrix is
 returned.}
}
}
\examples{
# For univariate continuous phase-type distributions
ph1 <- PH(matrix(c(-3, 0, 0, 1, -2, 0, 0, 1, -1), ncol = 3), c(0.25,0.25,0.5))
var(ph1)

# For multivariate continuous phase-type distributions
subintensity_matrix <- matrix(c(-3, 0, 0,
                               2, -2, 0,
                               0, 1, -1), nrow = 3, ncol = 3)
reward_matrix = matrix(sample(seq(0, 10), 6), nrow = 3, ncol = 2)
ph2 <- MPH(subintensity_matrix, reward_mat = reward_matrix)
## Variance-covariance matrix
var(ph2)
## Variance for the first state in the reward matrix
var(ph2, 1)
## Variance for the second state in the reward matrix
var(ph2, 2)

}
