% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms3.stat.R
\name{Lms3.stat}
\alias{Lms3.stat}
\title{Logarithmic minimum test for independence in three-way contingency table}
\usage{
Lms3.stat(nijt)
}
\arguments{
\item{nijt}{a numeric matrix with non-negative values of the three-way contingency table cells}
}
\value{
The function returns the value of the logarithmic minimum test statistic.
}
\description{
Calculates the statistic of the Logarithmic minimum test for independence in three-way contingency table
(see Sulewski P. (2018)).
}
\details{
The statistic of Logarithmic minimum test for independence in r x c x t contingency table,
see formula (6) in the article.
}
\examples{
Lms3.stat(table3)
Lms3.stat(GenTab3(array(1/12, dim=c(2,2,3)), 120))

}
\references{
{Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
