% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUPDC.R
\name{AUDPC}
\alias{AUDPC}
\title{Area Under the Disease Progress Curve (AUDPC)}
\usage{
AUDPC(time, severity)
}
\arguments{
\item{time}{A numeric vector of time points (e.g., days after sowing or inoculation).
Values must be in strictly increasing order.}

\item{severity}{A numeric vector of disease severity values
corresponding to each time point.}
}
\value{
A numeric value representing AUDPC.
}
\description{
Calculates the Area Under the Disease Progress Curve (AUDPC)
using the trapezoidal integration method.
}
\details{
AUDPC is calculated as:
\deqn{
AUDPC = \sum_{i=1}^{n-1} \frac{(Y_i + Y_{i+1})}{2} (T_{i+1} - T_i)
}

where \eqn{Y} is disease severity at time \eqn{T}.
}
\examples{
{
time <- c(0, 7, 14, 21, 28)
severity <- c(5, 15, 30, 45, 60)
AUDPC(time, severity)
}
}
