% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{titanic3}
\alias{titanic3}
\title{Titanic Survival Status}
\format{
A data frame with 1309 observations on the following 14 variables:
\describe{ 
\item{pclass}{a factor with levels \code{1st},
\code{2nd}, and \code{3rd}} 
\item{survived}{Survival (0 = No; 1 = Yes)} 
\item{name}{Name} 
\item{sex}{a factor with levels
\code{female} and \code{male}} 
\item{age}{age in years}
\item{sibsp}{Number of Siblings/Spouses Aboard}
\item{parch}{Number of Parents/Children Aboard}
\item{ticket}{Ticket Number} 
\item{fare}{Passenger Fare}
\item{cabin}{Cabin} 
\item{embarked}{a factor with levels
\code{Cherbourg}, \code{Queenstown}, and \code{Southampton}}
\item{boat}{Lifeboat} 
\item{body}{Body IdentificationNumber} 
\item{home.dest}{Home/Destination} }
}
\source{
\url{https://hbiostat.org/data/repo/titanic.html}
}
\description{
The \code{titanic3} data frame describes the survival status of individual
passengers on the Titanic.  The \code{titanic3} data frame does not contain
information for the crew, but it does contain actual and estimated ages for
almost 80\% of the passengers.
}
\details{
Thomas Cason of UVa has greatly updated and improved the \code{titanic} data
frame using the \emph{Encyclopedia Titanica} and created a new dataset
called \code{titanic3}. This dataset reflects the state of data available as
of August 2, 1999. Some duplicate passengers have been dropped, many errors
have been corrected, many missing ages have been filled in, and new
variables have been created.
}
\examples{

with(titanic3,
table(pclass, sex))

}
\references{
Harrell, F. E. (2001) \emph{Regression Modeling Strategies with
Applications to Linear Models, Logistic Regression, and Survival Analysis}.
Springer.
}
\keyword{datasets}
