% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRange_api_species.R
\name{OpenRange_api_species}
\alias{OpenRange_api_species}
\title{Download range maps for given species using the API.}
\usage{
OpenRange_api_species(species, directory, include_id = TRUE, ...)
}
\arguments{
\item{species}{A single species.}

\item{directory}{Directory that range maps should be saved in.}

\item{include_id}{Logical. Should the range_id be appended to the file name?  Needed to save multiple maps per species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
NULL. Called for its side effect of downloading range maps.
}
\description{
OpenRange_api_species downloads range maps for the specified species.
}
\note{
Details on the construction of BIEN range maps is available at http://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\donttest{

library(OpenRange)
library(maps) #a convenient source of maps
library(sf)
library(ggplot2)


# Create temp directory

temp_dir <- file.path(tempdir(), "BIEN_temp")

#Download ranges

OpenRange_api_species(species = "Abies_amabilis",
                      directory = temp_dir,
                      include_id = TRUE) # saves ranges to a temporary directory

#Reading files

Abies_poly <- st_read(dsn = temp_dir,
                      layer = "Abies_amabilis_117684")

# Get a map to plot on

world <- map("world", plot = FALSE, fill = TRUE)|>
  st_as_sf()

#Plotting files

ggplot(data = world)+
  geom_sf()+
  geom_sf(data = Abies_poly,
          fill="green")+
  coord_sf(xlim = st_bbox(Abies_poly)[c(1,3)],
           ylim = st_bbox(Abies_poly)[c(2,4)]) +
  theme_bw()

#Getting data from the files

Abies_poly |>
  st_drop_geometry()

}
}
\seealso{
Other range functions: 
\code{\link{OpenRange_api_load_species}()},
\code{\link{OpenRange_get_license}()},
\code{\link{OpenRange_get_stats}()},
\code{\link{OpenRange_list_scenarios}()},
\code{\link{OpenRange_load_species}()},
\code{\link{OpenRange_sf}()},
\code{\link{OpenRange_species}()}
}
\concept{range functions}
