% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRange_api_load_species.R
\name{OpenRange_api_load_species}
\alias{OpenRange_api_load_species}
\title{Load range maps for given species using the API.}
\usage{
OpenRange_api_load_species(species, ...)
}
\arguments{
\item{species}{A single species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Range maps for specified species.
}
\description{
OpenRange_api_load_species extracts range maps for the specified species.
}
\note{
Details on the construction of BIEN range maps is available at http://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\donttest{

library(maps) #a convenient source of maps
library(sf)

temp_dir <- file.path(tempdir(), "BIEN_temp")

#Download ranges
Abies_poly <- OpenRange_api_load_species(species = "Abies_amabilis")

#Plotting files
plot(Abies_poly[,1])#plots the range, but doesn't mean much without any reference
map('world', fill = TRUE, col = "grey")#plots a world map (WGS84 projection), in grey
plot(Abies_poly,col="forest green",add=TRUE) #adds the range to the map

#Getting data from the files
Abies_poly |>
 st_drop_geometry()

}
}
\seealso{
Other range functions: 
\code{\link{OpenRange_api_species}()},
\code{\link{OpenRange_get_license}()},
\code{\link{OpenRange_get_stats}()},
\code{\link{OpenRange_list_scenarios}()},
\code{\link{OpenRange_load_species}()},
\code{\link{OpenRange_sf}()},
\code{\link{OpenRange_species}()}
}
\concept{range functions}
