% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getCaseContinuousFeatures}
\alias{getCaseContinuousFeatures}
\title{Extract aggregate statistics of continuous feature analysis IDs of interest for targets}
\usage{
getCaseContinuousFeatures(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL,
  analysisIds = NULL,
  databaseIds = NULL,
  riskWindowStart = NULL,
  riskWindowEnd = NULL,
  startAnchor = NULL,
  endAnchor = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{analysisIds}{The feature extraction analysis ID of interest (e.g., 201 is condition)}

\item{databaseIds}{(optional) A vector of database IDs to restrict results to}

\item{riskWindowStart}{(optional) A vector of time-at-risk risk window starts to restrict to}

\item{riskWindowEnd}{(optional) A vector of time-at-risk risk window ends to restrict to}

\item{startAnchor}{(optional) A vector of time-at-risk start anchors to restrict to}

\item{endAnchor}{(optional) A vector of time-at-risk end anchors to restrict to}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{outcomeWashoutDays patients with the outcome occurring within this number of days prior to index are excluded (NA means no exclusion)}
 \item{riskWindowStart the time at risk start point}
 \item{riskWindowEnd the time at risk end point}
 \item{startAnchor the time at risk start point offset}
 \item{endAnchor the time at risk end point offset}
 \item{covariateName the name of the feature}
 \item{covariateId the id of the feature}
 \item{countValue the number of cases who have the feature}
 \item{minValue the minimum value observed for the feature}
 \item{maxValue the maximum value observed for the feature}
 \item{averageValue the mean value observed for the feature}
 \item{standardDeviation the standard deviation of the value observed for the feature}
 \item{medianValue the median value observed for the feature}
 \item{p10Value the 10th percentile of the value observed for the feature}
 \item{p25Value the 25th percentile of the value observed for the feature}
 \item{p75Value the 75th percentile of the value observed for the feature}
 \item{p90Value the 90th percentile of the value observed for the feature}
}
}
\description{
This function extracts the continuous feature extraction results for cases corresponding to specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

ccf <- getCaseContinuousFeatures(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
