% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getCaseBinaryFeatures}
\alias{getCaseBinaryFeatures}
\title{Extract aggregate statistics of binary feature analysis IDs of interest for cases}
\usage{
getCaseBinaryFeatures(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL,
  databaseIds = NULL,
  analysisIds = c(3),
  riskWindowStart = NULL,
  riskWindowEnd = NULL,
  startAnchor = NULL,
  endAnchor = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{databaseIds}{(optional) A vector of database ids to restrict to}

\item{analysisIds}{(optional) The feature extraction analysis ID of interest (e.g., 201 is condition)}

\item{riskWindowStart}{(optional) A vector of time-at-risk risk window starts to restrict to}

\item{riskWindowEnd}{(optional) A vector of time-at-risk risk window ends to restrict to}

\item{startAnchor}{(optional) A vector of time-at-risk start anchors to restrict to}

\item{endAnchor}{(optional) A vector of time-at-risk end anchors to restrict to}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{outcomeWashoutDays patients with the outcome occurring within this number of days prior to index are excluded (NA means no exclusion)}
\item{riskWindowStart the number of days ofset the start anchor that is the start of the time-at-risk}
\item{startAnchor the start anchor is either the target cohort start or cohort end date}
\item{riskWindowEnd the number of days ofset the end anchor that is the end of the time-at-risk}
\item{endAnchor the end anchor is either the target cohort start or cohort end date}
\item{covariateId the id of the feature}
\item{covariateName the name of the feature}
\item{sumValue the number of cases who have the feature value of 1}
\item{averageValue the mean feature value}
}
}
\description{
This function extracts the feature extraction results for cases corresponding to specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cbf <- getCaseBinaryFeatures(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
