% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{addTarColumn}
\alias{addTarColumn}
\title{addTarColumn}
\usage{
addTarColumn(data)
}
\arguments{
\item{data}{The data.frame with the individual TAR columns that you want to 
combine into one column}
}
\value{
The data data.frame object with the tar column added if seperate TAR columns are found
}
\description{
Finds the four TAR columns and creates a new column called tar that pastes the columns
into a nice string
}
\details{
Create a friendly single tar column
}
\examples{
addTarColumn(data.frame(
tarStartWith = 'cohort start',
tarStartOffset = 1,
tarEndWith = 'cohort start',
tarEndOffset = 0
))

}
\seealso{
Other helper: 
\code{\link{formatBinaryCovariateName}()},
\code{\link{getExampleConnectionDetails}()},
\code{\link{getOutcomeTable}()},
\code{\link{getTargetTable}()},
\code{\link{kableDark}()},
\code{\link{printReactable}()},
\code{\link{removeSpaces}()}
}
\concept{helper}
