% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prune_ODT.R
\name{plot.prune.ODT}
\alias{plot.prune.ODT}
\title{to plot pruned oblique decision tree}
\usage{
\method{plot}{prune.ODT}(x, position = "topleft", digits = NULL, main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link{prune.ODT}}.}

\item{position}{Position of the curve label, including "topleft" (default), "bottomright", "bottom", "bottomleft", "left", "top", "topright", "right" and "center".}

\item{digits}{Integer indicating the number of decimal places (round) or significant digits (signif) to be used.}

\item{main}{main title}

\item{...}{Arguments to be passed to methods.}
}
\value{
The leftmost value of the horizontal axis indicates the tree without pruning, while the rightmost value indicates the data without splitting and using the average value as the predicted value.
}
\description{
Plot the error graph of the pruned oblique decision tree at different split nodes.
}
\examples{
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])

tree <- ODT(Density ~ ., train_data, split = "mse")
prune_tree <- prune(tree, test_data[, -1], test_data[, 1])
# Plot pruned oblique decision tree structure (default)
plot(prune_tree)
# Plot the error graph of the pruned oblique decision tree.
class(prune_tree) <- "prune.ODT"
plot(prune_tree)

}
\seealso{
\code{\link{ODT}} \code{\link{prune.ODT}}
}
\keyword{plot}
\keyword{prune}
\keyword{tree}
