% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation_surplus.R
\name{calc_psp}
\alias{calc_psp}
\title{Calculate the precipitation surplus}
\usage{
calc_psp(B_LU_BRP, M_GREEN, M_GREEN_START = 10L, M_GREEN_TERMINATE = 3L)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{M_GREEN}{(boolean) A soil measure. Are catch crops sown after main crop (optional, options: TRUE, FALSE)}

\item{M_GREEN_START}{(integer) Month in which the green manure is sown}

\item{M_GREEN_TERMINATE}{(integer) Month in which the green manure is terminated, this month is included as month with green manure}
}
\value{
The estimated precipitation surplus (in mm / ha) depending on averaged precipitation and evaporation. A numeric value.
}
\description{
This function calculates the precipitation surplus (in mm / ha) given the crop rotation plan.
For the months with green manure (M_GREEN_START to and including M_GREEN_TERMINATE),
the makkink correction factor is increased to 0.6. If the value is already higher
than 0.6, no change is made to the makkink factor. For most cultivations, including
green manure decreases the precipitation suprlus by increasing the evapotranspiration.
}
\details{
This function is calculates a precipitation surplus over 12 months taking green
manures into account. The function does not take crop rotations or successive
years into account. As such, including a winter cereal, which modifies
evapotranspiration from January to August, does not alter the autumn 
evapotranspiration. If for example, a crop rotation includes potato followed by
winter wheat, the year with potato cultivation should have M_GREEN = TRUE.
The winter wheat acts as a green manure/catch crop for the potato's year.
}
\examples{
calc_psp(B_LU_BRP = 265, M_GREEN = TRUE)
calc_psp(B_LU_BRP = c(265,1019,265,1019), M_GREEN = rep(TRUE,4))
calc_psp(B_LU_BRP = c(2014, 2767), M_GREEN = rep(TRUE,2),
             M_GREEN_START = c(10L, 11L), M_GREEN_TERMINATE = c(12L, 3L))

}
