% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groundwater_recharge.R
\name{ind_gw_target}
\alias{ind_gw_target}
\title{Modify a groundwater recharge indicator with a target}
\usage{
ind_gw_target(D_RISK_GWR, B_SOILTYPE_AGR, B_GWL_CLASS, B_AREA_DROUGHT = FALSE)
}
\arguments{
\item{D_RISK_GWR}{(numeric) Groundwater recharge risk (distance to target, i.e. the 1 - I_E_GWR)}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{B_GWL_CLASS}{(character) The groundwater table class}

\item{B_AREA_DROUGHT}{(boolean) is the field located in an area with high risks for water deficiencies (options: TRUE or FALSE)}
}
\value{
D_OPI_GW (numeric) The opportunity index for groundwater recharge. 
This is the groundwater recharge indicator score modified by a target (nl: opgave).
This target is a measure for how relevant this soil function is given, in this
case, the soiltype and groundwaterclass.
}
\description{
This function modifiers the groundwater recharge indicator with a correction
factor based on the soiltype and groundwaterclass. Wetter groundwaterclasses
give higher values, peat gives higher values than clay, and clay higher than sand.
}
\examples{
ind_gw_target(0.5, 'zeeklei', 'IVu', FALSE)

}
