% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofic.r
\name{gofic}
\alias{gofic}
\title{Generic Goodness-of-Fit(GoF) and Model Diagnostics Function}
\usage{
gofic(x, params, dfun, pfun, plot = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{Numeric vector of observed data. Must contain at least two values.}

\item{params}{Named list of model parameters passed to \code{dfun} and \code{pfun}.}

\item{dfun}{A probability density function with signature
\code{dfun(x, ...)} returning numeric densities.}

\item{pfun}{A cumulative distribution function with signature
\code{pfun(q, ...)} returning cumulative probabilities.}

\item{plot}{Logical; if \code{TRUE}, plots empirical vs theoretical CDF.
Default is \code{TRUE}.}

\item{verbose}{Logical; if \code{TRUE}, prints the output object.
Default is \code{FALSE}.}
}
\value{
An object of class \code{"gofic"} containing:
\itemize{
  \item \code{logLik} Numeric; log-likelihood value.
  \item \code{AIC} Akaike Information Criterion.
  \item \code{BIC} Bayesian Information Criterion.
  \item \code{AICC} Corrected Akaike Information Criterion.
  \item \code{HQIC} Hannan–Quinn Information Criterion.
  \item \code{KS} Object returned by \code{stats::ks.test()}.
  \item \code{CVM} Object returned by \code{goftest::cvm.test()}.
  \item \code{AD} Object returned by \code{goftest::ad.test()}.
  \item \code{n} Sample size.
  \item \code{params} Model parameters supplied.
}

The object is returned invisibly.
}
\description{
Computes log-likelihood, information criteria (AIC, BIC, AICC, HQIC)
and classical goodness-of-fit statistics (Kolmogorov–Smirnov,
Cramér–von Mises, Anderson–Darling) for a given numeric data vector
and user-supplied density and distribution functions.
}
\details{
Optionally plots the empirical cumulative distribution function (ECDF)
against the theoretical cumulative distribution function.


The supplied \code{dfun} and \code{pfun} must accept arguments
\code{x} and \code{q} respectively, followed by named model parameters.
Density values must be finite and positive; non-positive densities
trigger a warning but computation proceeds.
}
\examples{
# Example 1 with built-in Weibull distribution
\donttest{
set.seed(123)
x <- rweibull(100, shape = 2, scale = 1)
out <- gofic(x, params = list(shape = 2, scale = 1),
      dfun = dweibull, pfun = pweibull, plot=FALSE)
out
}

# Example 2: For a user defined distribution
# Goodness-of-Fit(GoF) and Model Diagnostics for Chen-Exponential distribution
#Data
x <- stress
#ML Estimates    
params = list(alpha=2.5462, beta=0.0537, lambda=87.6028)
# Display plot and print numerical summary
gofic(x, params = params,
        dfun = dchen.exp, pfun = pchen.exp, plot = TRUE, verbose = TRUE)

# Display plot only (no numerical summary)
gofic(x, params = params,
        dfun = dchen.exp, pfun = pchen.exp, plot = TRUE, verbose = FALSE)

# Print numerical summary only (no plot)
gofic(x, params = params,
        dfun = dchen.exp, pfun = pchen.exp, plot = FALSE, verbose = TRUE)

# Display plot; numerical summary stored in 'out'
out <- gofic(x, params = params,
              dfun = dchen.exp, pfun = pchen.exp, plot = TRUE, verbose = FALSE)
print.gofic(out)

# Neither plot nor console output; results stored in 'out'
out <- gofic(x, params = params,
               dfun = dchen.exp, pfun = pchen.exp, plot = FALSE, verbose = FALSE)
print.gofic(out)

}
\seealso{
\code{\link{print.gofic}},
\code{\link[stats]{ks.test}},
\code{\link[goftest]{cvm.test}},
\code{\link[goftest]{ad.test}}
}
