% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisInvWeib.r
\name{PoisInvWeib}
\alias{PoisInvWeib}
\alias{dpois.inv.weib}
\alias{ppois.inv.weib}
\alias{qpois.inv.weib}
\alias{rpois.inv.weib}
\alias{hpois.inv.weib}
\title{Poisson Inverse Weibull Distribution}
\usage{
dpois.inv.weib(x, alpha, beta, lambda, log = FALSE)
ppois.inv.weib(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.inv.weib(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.inv.weib(n, alpha, beta, lambda)
hpois.inv.weib(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.inv.weib}: numeric vector of (log-)densities
  \item \code{ppois.inv.weib}: numeric vector of probabilities
  \item \code{qpois.inv.weib}: numeric vector of quantiles
  \item \code{rpois.inv.weib}: numeric vector of random variates
  \item \code{hpois.inv.weib}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Inverse Weibull distribution.
}
\details{
The Poisson Inverse Weibull distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Inverse Weibull distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1}{\left(1-e^{-\lambda}\right)}\left[1-\exp 
\left\{-\lambda \exp \left(-(\alpha / x)^\beta\right)
\right\}\right] \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.inv.weib(x, 2.0, 0.5, 0.2)
ppois.inv.weib(x, 2.0, 0.5, 0.2)
qpois.inv.weib(0.5, 2.0, 0.5, 0.2)
rpois.inv.weib(10, 2.0, 0.5, 0.2)
hpois.inv.weib(x, 2.0, 0.5, 0.2)

# Data
x <- fibers63
# ML estimates
params = list(alpha=5.5146, beta=1.8811, lambda=16.2341)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.inv.weib, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.inv.weib, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.inv.weib, pfun=ppois.inv.weib, plot=TRUE)
print.gofic(out)

}
\references{
Kus, C. (2007). A new lifetime distribution. 
\emph{Computational Statistics and Data Analysis}, \bold{51}, 4497--4509.

Joshi, R. K., & Kumar, V. (2021). 
Poisson Inverse Weibull Distribution with Theory and Applications. 
\emph{International Journal of Statistics and Systems}, \bold{16(1)}, 1--16. 

Rodrigues, G.C., Louzada, F., & Ramos, P.L.(2018). 
Poisson–exponential distribution: different methods of estimation. 
\emph{Journal of Applied Statistics}, \bold{45(1)}, 128--144.
}
