% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisNHE.r
\name{LogisNHE}
\alias{LogisNHE}
\alias{dlogis.NHE}
\alias{plogis.NHE}
\alias{qlogis.NHE}
\alias{rlogis.NHE}
\alias{hlogis.NHE}
\title{Logistic-NHE Distribution}
\usage{
dlogis.NHE(x, alpha, beta, lambda, log = FALSE)
plogis.NHE(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.NHE(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.NHE(n, alpha, beta, lambda)
hlogis.NHE(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.NHE}: numeric vector of (log-)densities
  \item \code{plogis.NHE}: numeric vector of probabilities
  \item \code{qlogis.NHE}: numeric vector of quantiles
  \item \code{rlogis.NHE}: numeric vector of random variates
  \item \code{hlogis.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-NHE distribution.
}
\details{
The Logistic-NHE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-NHE distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left[\exp \left\{(1+\lambda x)^\beta-1\right\}-1\right]^\alpha}  ; x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

Included functions are:
\itemize{
  \item \code{dlogis.NHE()} — Density function
  \item \code{plogis.NHE()} — Distribution function
  \item \code{qlogis.NHE()} — Quantile function
  \item \code{rlogis.NHE()} — Random generation
  \item \code{hlogis.NHE()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dlogis.NHE(x, 2.0, 5.0, 0.2)
plogis.NHE(x, 2.0, 5.0, 0.1)
qlogis.NHE(0.5, 2.0, 5.0, 0.1)
rlogis.NHE(10, 2.0, 5.0, 0.1)
hlogis.NHE(x, 2.0, 5.0, 0.1)

# Data
x <- conductors
# ML estimates
params = list(alpha=4.39078, beta=6.98955, lambda=0.01133)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.NHE, pfun=plogis.NHE, plot=TRUE)
print.gofic(out) 

}
\references{
Chaudhary,A.K., & Kumar, V.(2020). 
The Logistic NHE Distribution with Properties and Applications. 
\emph{International Journal for Research in Applied Science & Engineering 
Technology (IJRASET)}, \bold{8(12)},591--603. 
\doi{10.22214/ijraset.2020.32565}
}
