% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisGompertz.r
\name{LogisGompertz}
\alias{LogisGompertz}
\alias{dlogis.gpz}
\alias{plogis.gpz}
\alias{qlogis.gpz}
\alias{rlogis.gpz}
\alias{hlogis.gpz}
\title{Logistic-Gompertz Distribution}
\usage{
dlogis.gpz(x, alpha, beta, lambda, log = FALSE)
plogis.gpz(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.gpz(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.gpz(n, alpha, beta, lambda)
hlogis.gpz(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.gpz}: numeric vector of (log-)densities
  \item \code{plogis.gpz}: numeric vector of probabilities
  \item \code{qlogis.gpz}: numeric vector of quantiles
  \item \code{rlogis.gpz}: numeric vector of random variates
  \item \code{hlogis.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Gompertz distribution.
}
\details{
The Logistic-Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left[\exp \left\{\frac{\lambda}{\beta}
\left(e^{\beta x}-1\right)\right\}-1\right]^\alpha}  \, ; x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dlogis.gpz()} — Density function
  \item \code{plogis.gpz()} — Distribution function
  \item \code{qlogis.gpz()} — Quantile function
  \item \code{rlogis.gpz()} — Random generation
  \item \code{hlogis.gpz()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dlogis.gpz(x, 2.0, 1.5, 0.1)
plogis.gpz(x, 2.0, 1.5, 0.1)
qlogis.gpz(0.5, 2.0, 1.5, 0.1)
rlogis.gpz(10, 2.0, 1.5, 0.1)
hlogis.gpz(x, 2.0, 1.5, 0.1)

# Data
x <- stress
# ML estimates
params = list(alpha=2.09377, beta=0.30392, lambda=0.17763)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.gpz, pfun=plogis.gpz, plot=TRUE)
print.gofic(out)
}
\references{
Joshi, R. K.,  & Kumar, V. (2020). 
The Logistic Gompertz Distribution with Properties and Applications. 
\emph{Bull. Math. & Stat. Res.},  \bold{8(4)}, 81--94.
}
