% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisChen.r
\name{LogisChen}
\alias{LogisChen}
\alias{dlogis.chen}
\alias{plogis.chen}
\alias{qlogis.chen}
\alias{rlogis.chen}
\alias{hlogis.chen}
\title{Logistic-Chen Distribution}
\usage{
dlogis.chen(x, alpha, beta, lambda, log = FALSE)
plogis.chen(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.chen(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.chen(n, alpha, beta, lambda)
hlogis.chen(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.chen}: numeric vector of (log-)densities
  \item \code{plogis.chen}: numeric vector of probabilities
  \item \code{qlogis.chen}: numeric vector of quantiles
  \item \code{rlogis.chen}: numeric vector of random variates
  \item \code{hlogis.chen}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Chen distribution.
}
\details{
The Logistic-Chen distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Chen distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left[\exp \left\{\lambda\left
(e^{x^\beta}-1\right)\right\}-1\right]^\alpha}  \, ; \quad x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.chen()} — Density function
  \item \code{plogis.chen()} — Distribution function
  \item \code{qlogis.chen()} — Quantile function
  \item \code{rlogis.chen()} — Random generation
  \item \code{hlogis.chen()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.1)
dlogis.chen(x, 1.5, 1.5, 0.1)
plogis.chen(x, 1.5, 1.5, 0.1)
qlogis.chen(0.5, 1.5, 1.5, 0.1)
rlogis.chen(10, 2.0, 5.0, 0.1)
hlogis.chen(x, 1.5, 1.5, 0.1)

# Data
x <- bladder
# ML estimates
params = list(alpha=4.46424, beta=0.15506, lambda=0.24904)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.chen, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.chen, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.chen, pfun=plogis.chen, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R.K., & Kumar, V. (2021). 
Logistic Chen Distribution with Properties and Applications.
\emph{International Journal of Mathematics Trends and Technology (IJMTT)},
\bold{67(1)}, 141--151. 
\doi{10.14445/22315373/IJMTT-V67I1P519}
}
