% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyGenInvExp.r
\name{LindleyGIE}
\alias{LindleyGIE}
\alias{dlind.ginv.exp}
\alias{plind.ginv.exp}
\alias{qlind.ginv.exp}
\alias{rlind.ginv.exp}
\alias{hlind.ginv.exp}
\title{Lindley Generalized Inverted Exponential(LGIE) Distribution}
\usage{
dlind.ginv.exp(x, alpha, lambda, theta, log = FALSE)
plind.ginv.exp(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlind.ginv.exp(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlind.ginv.exp(n, alpha, lambda, theta)
hlind.ginv.exp(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlind.ginv.exp}: numeric vector of (log-)densities
  \item \code{plind.ginv.exp}: numeric vector of probabilities
  \item \code{qlind.ginv.exp}: numeric vector of quantiles
  \item \code{rlind.ginv.exp}: numeric vector of random variates
  \item \code{hlind.ginv.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the LGIE distribution.
}
\details{
The LGIE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The LGIE distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
1-\left(1-e^{-\lambda / x}\right)^{\alpha \theta}\left[1-\left(\frac{\theta}
{\theta+1}\right) \ln \left(1-e^{-\lambda / x}\right)^\alpha\right]  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlind.ginv.exp()} — Density function
  \item \code{plind.ginv.exp()} — Distribution function
  \item \code{qlind.ginv.exp()} — Quantile function
  \item \code{rlind.ginv.exp()} — Random generation
  \item \code{hlind.ginv.exp()} — Hazard function
}
}
\examples{
x <- seq(5, 10, 0.2)
dlind.ginv.exp(x, 5.0, 1.5, 0.5)
plind.ginv.exp(x, 5.0, 1.5, 0.5)
qlind.ginv.exp(0.5, 5.0, 1.5, 0.5)
rlind.ginv.exp(10, 5.0, 1.5, 0.5)
hlind.ginv.exp(x, 5.0, 1.5, 0.5)

# Data
x <- conductors
# ML estimates
params = list(alpha=97.0105, lambda=29.9324, theta=0.9028)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plind.ginv.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlind.ginv.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlind.ginv.exp, pfun=plind.ginv.exp, plot=FALSE)
print.gofic(out)

}
\references{
Telee, L. B. S., & Kumar, V. (2021).
Lindley Generalized Inverted Exponential Distribution: Model and Applications.
\emph{Pravaha}, \bold{27(1)}, 61--72. \doi{10.3126/pravaha.v27i1.50616}   

Yadav, R.S., & Kumar, V. (2020). Arctan Generalized Inverted Exponential Distribution. 
\emph{J. Nat. Acad. Math.}, \bold{34}, 71--92.
}
