% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCInvGPZ.r
\name{HCInvGPZ}
\alias{HCInvGPZ}
\alias{dhc.inv.gpz}
\alias{phc.inv.gpz}
\alias{qhc.inv.gpz}
\alias{rhc.inv.gpz}
\alias{hhc.inv.gpz}
\title{Half-Cauchy Inverse Gompertz Distribution}
\usage{
dhc.inv.gpz(x, alpha, lambda, theta, log = FALSE)
phc.inv.gpz(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.inv.gpz(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.inv.gpz(n, alpha, lambda, theta)
hhc.inv.gpz(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.inv.gpz}: numeric vector of (log-)densities
  \item \code{phc.inv.gpz}: numeric vector of probabilities
  \item \code{qhc.inv.gpz}: numeric vector of quantiles
  \item \code{rhc.inv.gpz}: numeric vector of random variates
  \item \code{hhc.inv.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy Inverse Gompertz distribution.
}
\details{
The Half-Cauchy Inverse Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Half-Cauchy Inverse Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad 1 - \frac{2}{\pi }\arctan \left\{ { - \frac{\lambda }{{\alpha \theta }}
\left( {1 - {e^{\alpha /x}}} \right)} \right\}  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dhc.inv.gpz()} — Density function
  \item \code{phc.inv.gpz()} — Distribution function
  \item \code{qhc.inv.gpz()} — Quantile function
  \item \code{rhc.inv.gpz()} — Random generation
  \item \code{hhc.inv.gpz()} — Hazard function
}
}
\examples{
x <- seq(1.0, 10, 0.25)
dhc.inv.gpz(x, 2.0, 0.5, 2.5)
phc.inv.gpz(x, 2.0, 0.5, 2.5)
qhc.inv.gpz(0.5, 2.0, 0.5, 2.5)
rhc.inv.gpz(10, 2.0, 0.5, 2.5)
hhc.inv.gpz(x, 2.0, 0.5, 2.5)

# Data
x <- relief
# ML estimates
params = list(alpha=9.0830, lambda=0.8369, theta=17.9925)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.inv.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.inv.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dhc.inv.gpz, pfun=phc.inv.gpz, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A. K., Yadav, R. S., & Kumar, V. (2022).
Half-Cauchy Inverse Gompertz distribution: Theory and applications.
\emph{International Journal of Statistics and Applied Mathematics},
\bold{7}(5), 94--102. \doi{10.22271/maths.2022.v7.i5b.885}
}
