% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_core_helpers.R
\name{el_run_solver}
\alias{el_run_solver}
\title{Solver orchestration}
\usage{
el_run_solver(
  equation_system_func,
  analytical_jac_func,
  init,
  final_control,
  top_args,
  solver_method,
  use_solver_jac,
  K_beta,
  K_aux,
  respondent_weights,
  N_pop,
  trace_level = 0
)
}
\arguments{
\item{equation_system_func}{Function mapping parameter vector to equation residuals.}

\item{analytical_jac_func}{Analytic Jacobian function; may be NULL if unavailable or when forcing Broyden.}

\item{init}{Numeric vector of initial parameter values.}

\item{final_control}{List passed to \code{nleqslv::nleqslv(control = ...)}.}

\item{top_args}{List of top-level \code{nleqslv::nleqslv} args (e.g., \code{global}, \code{xscalm}).}

\item{solver_method}{Character; one of "auto", "newton", or "broyden".}

\item{use_solver_jac}{Logical; whether to pass analytic Jacobian to Newton.}

\item{K_beta}{Integer; number of response model parameters.}

\item{K_aux}{Integer; number of auxiliary constraints.}

\item{respondent_weights}{Numeric vector of base sampling weights.}

\item{N_pop}{Numeric; population total.}

\item{trace_level}{Integer; verbosity level.}
}
\description{
Solver orchestration
}
\keyword{internal}
