% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_events_abcd}
\alias{filter_events_abcd}
\title{Filter ABCD events}
\usage{
filter_events_abcd(data, conditions, connect = "and")
}
\arguments{
\item{data}{tibble. The data to be filtered.}

\item{conditions}{character (vector). The events to keep.}

\item{connect}{character. Whether to connect the conditions with \code{"and"}
(an event is retained if \emph{all} conditions are met; the default) or \code{"or"}
(an event is retained if \emph{any} condition is met).}
}
\value{
A tibble with the filtered data.
}
\description{
Given a (set of) condition(s), filters the events included in an ABCD
dataset. Conditions can be specified as a vector of strings, where each
string can be one of the following conditions:
\itemize{
\item \code{"core"}: events for the ABCD core study
\item \code{"annual"}: annual events for the ABCD core study
\item \code{"mid_year"}: mid-year events for the ABCD core study
\item \code{"substudy"}: events for ABCD substudies
\item \code{"covid"}: events for the COVID substudy
\item \code{"sdev"}: events for the Social Development substudy
\item \code{"even"}: even-numbered events
\item \code{"odd"}: odd-numbered events
\item numerical expressions like \verb{>2} or \verb{<=5} to filter events by number
\item any other string to be used as filter for the \code{session_id} column
}

The conditions can be combined with logical \code{"and"} or \code{"or"}.
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- tibble::tribble(
  ~session_id,     ~study,     ~type,
  "ses-00S",       "core",     "screener",
  "ses-00M",       "core",     "mid-year",
  "ses-00A",       "core",     "even",
  "ses-01M",       "core",     "mid-year",
  "ses-01A",       "core",     "odd",
  "ses-02M",       "core",     "mid-year",
  "ses-02A",       "core",     "even",
  "ses-03M",       "core",     "mid-year",
  "ses-03A",       "core",     "odd",
  "ses-04M",       "core",     "mid-year",
  "ses-04A",       "core",     "even",
  "ses-05M",       "core",     "mid-year",
  "ses-05A",       "core",     "odd",
  "ses-06M",       "core",     "mid-year",
  "ses-06A",       "core",     "even",
  "ses-C01",       "substudy", "covid",
  "ses-C02",       "substudy", "covid",
  "ses-C03",       "substudy", "covid",
  "ses-C04",       "substudy", "covid",
  "ses-C05",       "substudy", "covid",
  "ses-C06",       "substudy", "covid",
  "ses-C07",       "substudy", "covid",
  "ses-S01",       "substudy", "sdev",
  "ses-S02",       "substudy", "sdev",
  "ses-S03",       "substudy", "sdev",
  "ses-S04",       "substudy", "sdev",
  "ses-S05",       "substudy", "sdev"
)

# ABCD core study events
filter_events_abcd(data, c("core"))

# COVID substudy events
filter_events_abcd(data, c("covid"))

# imaging events
filter_events_abcd(data, c("annual", "even"))

# mid-years before year 5
filter_events_abcd(data, c("mid_year", "<5"))

# COVID or Social Development substudy events
filter_events_abcd(data, c("covid", "sdev"), connect = "or")
\dontshow{\}) # examplesIf}
}
